--========================================================================================================
-- qb-animalzones (config) Written per ILoveNopixelILoveYou (Highleak.com)
--========================================================================================================
Config = {}
local vec3 = vector3 -- alias côté client & serveur

--===========================================================
-- Performance & logique [#10]
--===========================================================
Config.TickIntervalMs           = 1000          -- cadence serveur (1s)
Config.ClientTickMs             = 750           -- cadence client (contrôleur)
Config.HeartbeatMs              = 2000          -- heartbeat client -> serveur
Config.SpawnPerTick             = 2             -- nb max de créations d'animaux par tick client
Config.CadaverDespawnMs         = 120000        -- 2 minutes de persistance des cadavres [#4]
Config.AttackRefreshMs          = 1500          -- re-ciblage des attaques (multijoueur) [#6]
Config.ControllerMaxDistance    = 800.0         -- distance max pour être éligible contrôleur (ajoutée au radius)
Config.PreSpawnBuffer           = 120.0         -- marge externe pour pré-spawn [#5]
Config.DespawnFarMargin         = 250.0         -- si TOUS les joueurs sont au-delà de radius+margin -> despawn [#7]
Config.StaleHeartbeatMs         = 5000          -- au-delà, une présence n'est plus comptée
Config.AdoptScanMs              = 6000          -- optimisation: scan d'adoption des animaux existants max toutes les 6s

--===========================================================
-- Spawn & sécurité [#1,#2,#5]
--===========================================================
Config.MinSpawnSeparation       = 18.0          -- distance mini entre animaux (pas même point) [#2]
Config.MinSpawnToPlayer         = 65.0          -- anti pop-in : pas d'apparition proche joueur [#2]
Config.SpawnZProbe              = true          -- ajuster Z via raycast pour poser au sol
Config.AntiSlideOnSpawn         = true

--===========================================================
-- Agressivité [#3]
--===========================================================
Config.Aggressive               = true
Config.AggressivenessScale      = 1.0           -- 1.0 = 100 % (paramétrable)
Config.AnimalMaxSight           = 85.0
Config.AnimalMaxHearing         = 80.0

--===========================================================
-- Exemptions, coma, jobs [#11,#12,#13]
--===========================================================
Config.ExemptJobs               = { 'police', 'ambulance' } -- si présent DANS la zone: pas de spawn [#13]
Config.ComaMetaKeys             = { 'isdead', 'inlaststand' } -- QBCore metadata (fallback natives côté client)
Config.Debug                    = false

--===========================================================
-- Modèles [#8] — jusqu'à 6 modèles, un seul par zone
--===========================================================
Config.AnimalModels = {
    boar   = `a_c_boar`,
    cougar = `a_c_mtlion`,
    coyote = `a_c_coyote`,
    deer   = `a_c_deer`,
    husky  = `a_c_husky`,
    rott   = `a_c_rottweiler`,
}

-- Santé par modèle [#14]
-- Les clés utilisent les hashes de modèles pour une concordance exacte.
Config.HealthPerModel = {
    [Config.AnimalModels.boar]   = 180,
    [Config.AnimalModels.cougar] = 220,
    [Config.AnimalModels.coyote] = 140,
    [Config.AnimalModels.deer]   = 160,
    [Config.AnimalModels.husky]  = 130,
    [Config.AnimalModels.rott]   = 150,
}
-- Valeur par défaut si un modèle n'est pas listé ci‑dessus
Config.DefaultAnimalHealth = 150


--===========================================================
-- Medical bridge (EMS compatibility)
--===========================================================
Config.MedicalBridge = {
    -- Add extra job names that should block spawns when inside a zone.
    ExtraExemptJobs = { 'ems', 'medic', 'sams', 'nhs', 'osp_ambulance' },
    -- If your ambulance script uses custom statebag keys for death/laststand, list them here:
    CustomStateKeys = { 'downed', 'coma', 'incapacitated' }, -- checked in this order
}

--===========================================================
-- Zones — nombre constant, configurable [#1]
--===========================================================
Config.Zones = {
    {
        id = "raton_canyon_cougars",
        label = "Raton Canyon – Cougars",
        center = vec3(-1378.0, 4676.0, 45.0),
        radius = 280.0,            -- grande zone de déclenchement
        spawnRadius = 180.0,       -- couronne d'apparition (sera clampée à <= radius) [<= radius]
        animalModel = Config.AnimalModels.cougar,
        animalCount = 6,           -- nombre constant [#1]
    },
    {
        id = "chiliad_coyotes",
        label = "Mont Chiliad – Coyotes",
        center = vec3(1632.0, 4700.0, 42.0),
        radius = 260.0,
        spawnRadius = 170.0,
        animalModel = Config.AnimalModels.coyote,
        animalCount = 8,
    },
    {
        id = "alamo_deer",
        label = "Alamo – Cerfs",
        center = vec3(1615.0, 3655.0, 34.0),
        radius = 260.0,
        spawnRadius = 180.0,
        animalModel = Config.AnimalModels.deer,
        animalCount = 10,
    },
}

-- Index rapide des zones par identifiant
Config.ZonesById = {}
for _, z in ipairs(Config.Zones) do
    Config.ZonesById[z.id] = z
end

--=====================================================================
-- Fin de configuration
--=====================================================================
