--========================================================================================================
-- qb-animalzones (CLIENT bridge for ambulance jobs) Written per ILoveNopixelILoveYou (Highleak.com)
--========================================================================================================

---@return boolean|nil  -- true si coma/mort, false si vivant, nil si inconnu
function AnimalZones_IsPlayerComaBridge()
    -- 1) Exports officiels d'abord (Wasabi, Brutal, Arius, Andyyy, Illenium...)
    local exportChecks = {
        -- resourceName, functionName
        {'wasabi_ambulance',      'isPlayerDead'},
        {'brutal_ambulancejob',   'IsDead'},
        {'arius_ambulance',       'IsPlayerDead'},
        {'andyyy_ambulance',      'IsDead'},
        {'illenium-ambulance',    'IsPlayerDead'},
    }
    for _, pair in ipairs(exportChecks) do
        local resName, fn = pair[1], pair[2]
        if GetResourceState(resName) == 'started' then
            local ok, val = pcall(function()
                -- IMPORTANT: appeler l'export SANS passer exports[...] en paramètre
                return exports[resName][fn]()
            end)
            if ok and type(val) == 'boolean' then return val end
        end
    end

    -- 2) Statebags joueur local
    local lp = LocalPlayer
    if lp and lp.state then
        local st = lp.state
        if st.isDead ~= nil then return st.isDead end
        if st.inLaststand ~= nil then return st.inLaststand end
        if st.isInLaststand ~= nil then return st.isInLaststand end
        if st.dead ~= nil then return st.dead end
    end

    -- 3) Fallback metadata QBCore selon Config.ComaMetaKeys
    if Config and Config.ComaMetaKeys then
        local okCore, QBCore = pcall(function()
            return exports['qb-core'] and exports['qb-core']:GetCoreObject()
        end)
        if okCore and QBCore and QBCore.Functions and QBCore.Functions.GetPlayerData then
            local data = QBCore.Functions.GetPlayerData()
            if data and data.metadata then
                for _, key in ipairs(Config.ComaMetaKeys or {}) do
                    local v = data.metadata[key]
                    if v == true then return true end
                end
            end
        end
    end

    -- 4) Inconnu -> laisser la logique de base retomber sur exports qb-hospital, puis natives GTA.
    return nil
end
